<?php
// bot.php
require_once 'config.php';
require_once 'functions.php';
require_once 'user_panel.php';

// --- INITIALIZATION ---
header('Content-Type: application/json'); http_response_code(200);
$update = json_decode(file_get_contents('php://input'), true);
if (!$update) exit;

$chat_id = $update['message']['chat']['id'] ?? $update['callback_query']['message']['chat']['id'] ?? 0;
$user_id = $update['message']['from']['id'] ?? $update['callback_query']['from']['id'] ?? 0;
if (!$chat_id || !$user_id) exit;

global $db;
$user_state = $db->query("SELECT is_admin FROM users WHERE user_id = $user_id")->fetch_assoc()['is_admin'] ?? 0;

// --- ROUTING ---
if (isset($update['callback_query'])) {
    handle_callback_query($chat_id, $user_id, $update['callback_query'], $user_state);
} elseif (isset($update['message'])) {
    handle_message($chat_id, $user_id, $update['message'], $user_state);
}

// --- MESSAGE HANDLER ---
function handle_message($chat_id, $user_id, $message, $user_state) {
    $text = $message['text'] ?? '';

    if ($text === '/start') {
        if (getSetting('is_membership_required') == '1' && !isMainAdmin($user_id) && !checkMembership($user_id)) {
             $channels = getChannelList();
             $msg = "🔒 لطفاً برای استفاده از ربات، ابتدا در کانال‌های زیر عضو شوید:\n\n" . implode("\n", $channels);
             sendMessage($chat_id, $msg, ['inline_keyboard' => [[['text' => '✅ عضو شدم', 'callback_data' => 'start']]]]);
             return;
        }

        global $db;
        $stmt = $db->prepare("INSERT INTO users (user_id, is_admin) VALUES (?, 0) ON DUPLICATE KEY UPDATE user_id=VALUES(user_id)");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        clearAdminContext($user_id);
        
        $is_user_admin = isAdmin($user_id);
        
        $keyboard = ['inline_keyboard' => []];
        if ($is_user_admin) {
            $keyboard['inline_keyboard'][] = [['text' => '🛠 پنل ادمین', 'callback_data' => 'admin_panel']];
        }
        $keyboard['inline_keyboard'][] = [['text' => '🔍 جستجو', 'callback_data' => 'search'], ['text' => '🔥 پر دانلودها', 'callback_data' => 'top_downloads']];
        
        sendMessage($chat_id, "🎬 به ربات سینما گریت خوش آمدید!", $keyboard);
        return;
    }
    
     if (!isAdmin($user_id) && getSetting('is_membership_required') == '1' && !checkMembership($user_id)) { $channels = getChannelList(); $msg = "🔒 لطفاً برای استفاده از ربات، ابتدا در کانال‌های زیر عضو شوید:\n\n" . implode("\n", $channels); sendMessage($chat_id, $msg, ['inline_keyboard' => [[['text' => '✅ عضو شدم', 'callback_data' => 'start']]]]); return; }
    
    if($text === '/done' && isAdmin($user_id)) {
        $context = getAdminContext($user_id);
        $keyboard_rows = [];
        $keyboard_rows[] = [['text'=>' بازگشت به پنل ادمین', 'callback_data'=>'admin_panel']];
        
        if (!empty($context['admin_context_imdb'])) {
            $imdb_id = $context['admin_context_imdb'];
            $season = $context['admin_context_season'] ?? 'movie';
            $keyboard_rows[] = [['text'=>'⬆️ آپلود کیفیت دیگر', 'callback_data'=>"reupload_{$imdb_id}_{$season}"]];
        }
        
        sendMessage($chat_id, "✅ عملیات با موفقیت پایان یافت.", ['inline_keyboard' => $keyboard_rows]);
        clearAdminContext($user_id);
        return;
    }

    $context = getAdminContext($user_id);
    if (isAdmin($user_id) && !empty($context['admin_context_imdb']) && !empty($context['admin_context_quality']) && !is_null($context['admin_context_subtitle']) && (isset($message['video']) || isset($message['document']))) { handle_file_upload($chat_id, $user_id, $message, $context); return; }
    
    if (isAdmin($user_id) && $user_state > 1 && $user_state < 99 && handle_admin_text_input($chat_id, $user_id, $message, $user_state, $context)) {
        return;
    }

    handleUserInput($chat_id, $user_id, $text, $message['entities'] ?? []);
}

function handle_admin_text_input($chat_id, $user_id, $message, $user_state, $context) {
    global $db; $text = $message['text'] ?? '';
    // --- STANDARDIZED BUTTON OBJECT ---
    $cancel_button = ['text' => '🔙 انصراف و بازگشت به پنل', 'callback_data' => 'admin_panel'];

    if ($user_state == 2 || $user_state == 3) {
        $imdb_id = extractIMDbID($text, $message['entities'] ?? []);
        if ($imdb_id && $info = getIMDbInfo($imdb_id)) {
            setAdminContext($user_id, $imdb_id);
            $safe_title = htmlspecialchars($info['title']);
            if ($user_state == 2) { // Movie
                $keyboard_rows = generateDynamicQualityKeyboard($imdb_id);
                $keyboard_rows[] = [['text' => '➕ کیفیت جدید (متنی)', 'callback_data' => 'quality_custom']];
                $keyboard_rows[] = [$cancel_button]; // Correct usage
                $kb = ['inline_keyboard' => $keyboard_rows];
                sendMessage($chat_id, "✅ فیلم <code>{$safe_title}</code>. کیفیت را انتخاب کنید:", $kb);
            
            } else { // Series
                $stmt = $db->prepare("SELECT DISTINCT season FROM series WHERE imdb_id = ? ORDER BY season ASC");
                $stmt->bind_param("s", $imdb_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $season_buttons = [];
                while ($row = $result->fetch_assoc()) {
                    $season_num = $row['season'];
                    $season_buttons[] = ['text' => "🗓 فصل {$season_num}", 'callback_data' => "season_{$season_num}"];
                }
                
                $keyboard_rows = array_chunk($season_buttons, 2);
                $keyboard_rows[] = [['text' => '➕ فصل جدید', 'callback_data' => 'add_new_season']];
                $keyboard_rows[] = [$cancel_button]; // Correct usage
                $kb = ['inline_keyboard' => $keyboard_rows];
                $msg = "✅ سریال <code>{$safe_title}</code>. فصل موجود را انتخاب کنید یا فصل جدیدی اضافه نمایید:";
                if (empty($season_buttons)) {
                    $msg = "✅ سریال <code>{$safe_title}</code>. فصلی برای این سریال یافت نشد. لطفاً فصل جدید را اضافه کنید:";
                }
                sendMessage($chat_id, $msg, $kb);
            }
        } else { sendMessage($chat_id, "❌ لینک IMDb نامعتبر است. مجددا ارسال کنید."); } return true;
    }

    if ($user_state == 14) {
        $imdb_id = extractIMDbID($text, $message['entities'] ?? []);
        if ($imdb_id) {
            $stmt_movies = $db->prepare("SELECT id FROM movies WHERE imdb_id = ?");
            $stmt_movies->bind_param("s", $imdb_id);
            $stmt_movies->execute();
            $movie_exists = $stmt_movies->get_result()->num_rows > 0;
            $stmt_movies->close();

            $stmt_series = $db->prepare("SELECT id FROM series WHERE imdb_id = ?");
            $stmt_series->bind_param("s", $imdb_id);
            $stmt_series->execute();
            $series_exists = $stmt_series->get_result()->num_rows > 0;
            $stmt_series->close();

            if ($movie_exists || $series_exists) {
                $info = getIMDbInfo($imdb_id);
                $safe_title = htmlspecialchars($info['title'] ?? $imdb_id); 
                $message_text = "✅ محتوای <code>{$safe_title}</code> در دیتابیس یافت شد. نوع حذف را مشخص کنید:";
                
                $kb = [ 'inline_keyboard' => [
                    [['text' => '❌ حذف کلی محتوا', 'callback_data' => 'confirm_delete_all_prompt_' . $imdb_id]],
                    [['text' => '🗑 حذف جزئی (فایل خاص)', 'callback_data' => 'pdel_start_' . $imdb_id]],
                    [$cancel_button] // Correct usage
                ]];
                
                $response = sendMessage($chat_id, $message_text, $kb);
                if (!$response || !$response['ok']) {
                    logMessage("ERROR: sendMessage failed in state 14. Telegram response: " . json_encode($response));
                    sendMessage($chat_id, "⚠️ خطایی در ارسال پیام به تلگرام رخ داد. لطفاً لاگ ربات را بررسی کنید.");
                }
            } else {
                sendMessage($chat_id, "❌ محتوایی با این لینک (<code>$imdb_id</code>) در دیتابیس یافت نشد که حذف شود.");
            }
        } else {
            sendMessage($chat_id, "❌ لینک IMDb نامعتبر است. لطفاً لینک صحیح را ارسال کنید.");
        }
        clearAdminContext($user_id);
        return true;
    }
    
    switch ($user_state) {
        case 6: if (is_numeric($text)) {
            setAdminContext($user_id, $context['admin_context_imdb'], intval($text));
            $keyboard_rows = generateDynamicQualityKeyboard($context['admin_context_imdb'], intval($text));
            $keyboard_rows[] = [['text' => '➕ کیفیت جدید', 'callback_data' => 'quality_custom']];
            $keyboard_rows[] = [$cancel_button]; // Correct usage
            $kb = ['inline_keyboard' => $keyboard_rows];
            sendMessage($chat_id, "✅ فصل $text انتخاب شد. کیفیت را انتخاب کنید:", $kb);
            } else { sendMessage($chat_id, "لطفا فقط عدد وارد کنید.");} return true;
        case 7: 
            setAdminContext($user_id, $context['admin_context_imdb'], $context['admin_context_season'], $text);
            $kb = [ 'inline_keyboard' => [
                    [['text' => '📝 زیرنویس' . (in_array('subtitle', getExistingSubtypesForQuality($context['admin_context_imdb'], $context['admin_context_season'], $text)) ? ' 🌟' : ''), 'callback_data' => 'subtitle_subtitle']],
                    [['text' => '🎙 دوبله فارسی' . (in_array('dubbed', getExistingSubtypesForQuality($context['admin_context_imdb'], $context['admin_context_season'], $text)) ? ' 🌟' : ''), 'callback_data' => 'subtitle_dubbed']],
                    [['text' => '📁 فایل اصلی' . (in_array('', getExistingSubtypesForQuality($context['admin_context_imdb'], $context['admin_context_season'], $text)) ? ' 🌟' : ''), 'callback_data' => 'subtitle_none']],
                    [$cancel_button] // Correct usage
                ]];
            sendMessage($chat_id, "✅ کیفیت <code>" . htmlspecialchars($text) . "</code> انتخاب شد. نوع فایل را مشخص کنید:", $kb); return true;
        case 8: $stmt = $db->query("SELECT user_id FROM users"); $users = $stmt->fetch_all(MYSQLI_ASSOC); foreach ($users as $u) { sendMessage($u['user_id'], $text); } sendMessage($chat_id, "✅ پیام همگانی به " . count($users) . " کاربر ارسال شد."); clearAdminContext($user_id); return true;
        case 10: if(is_numeric($text)) { $db->query("INSERT INTO users (user_id, is_admin) VALUES ($text, 1) ON DUPLICATE KEY UPDATE is_admin=1"); sendMessage($chat_id, "✅ کاربر $text به ادمین‌ها اضافه شد."); clearAdminContext($user_id); } else { sendMessage($chat_id, "لطفا فقط آیدی عددی کاربر را وارد کنید.");} return true;
        case 13: if(is_numeric($text)) { if (in_array($text, ADMIN_IDS)) { sendMessage($chat_id, "⚠️ شما نمی‌توانید ادمین اصلی را حذف کنید."); } else { $db->query("UPDATE users SET is_admin=0 WHERE user_id=$text"); sendMessage($chat_id, "✅ کاربر $text از ادمین‌ها حذف شد."); clearAdminContext($user_id); } } else { sendMessage($chat_id, "لطفا فقط آیدی عددی وارد کنید.");} return true;
        case 4: if ($text == '/done') { sendMessage($chat_id, "✅ تنظیمات کانال ذخیره شد."); clearAdminContext($user_id); } else { if(strpos($text, '@') === 0) { $channels = getChannelList(); if(in_array($text, $channels)) { removeChannel($text); sendMessage($chat_id, "✅ کانال $text حذف شد."); } else { addChannel($text); sendMessage($chat_id, "✅ کانال $text اضافه شد."); } } else { sendMessage($chat_id, "لطفا آیدی کانال را با @ وارد کنید."); } } return true;
        case 5:
            if ($text == '/no_ad') {
                updateSetting('ad_message', '');
                sendMessage($chat_id, "✅ تبلیغات حذف شد.");
            } else {
                $ad_parts = explode('---', $text, 2);
                if (isset($ad_parts[1]) && json_decode(trim($ad_parts[1]), true) === null) {
                    sendMessage($chat_id, "❌ فرمت دکمه‌ها (JSON) نامعتبر است. لطفاً ساختار را بررسی و مجدداً ارسال کنید.");
                    return true;
                }
                updateSetting('ad_message', $text);
                sendMessage($chat_id, "✅ تبلیغات با موفقیت ثبت شد.");
            }
            clearAdminContext($user_id);
            return true;
    }
    return false;
}

function handle_file_upload($chat_id, $user_id, $message, $context) {
    global $db; $file_id = $message['video']['file_id'] ?? $message['document']['file_id'];
    $imdb_id = $context['admin_context_imdb']; $quality = $context['admin_context_quality'];
    $subtitle = $context['admin_context_subtitle']; $season = $context['admin_context_season'];
    $info = getIMDbInfo($imdb_id); $title = $info['title'] ?? 'Unknown Title';
    
    $movie_count_before = $db->query("SELECT COUNT(*) as c FROM movies WHERE imdb_id = '$imdb_id'")->fetch_assoc()['c'] ?? 0;
    $series_count_before = $db->query("SELECT COUNT(*) as c FROM series WHERE imdb_id = '$imdb_id'")->fetch_assoc()['c'] ?? 0;
    $is_new_entry = ($movie_count_before + $series_count_before) === 0;

    if (is_null($season)) {
        $stmt = $db->prepare("INSERT INTO movies (imdb_id, title, quality, subtitle_dubbed, file_id) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $imdb_id, $title, $quality, $subtitle, $file_id); $stmt->execute();
        sendMessage($chat_id, "✅ فایل فیلم ذخیره شد. فایل بعدی یا /done");
    } else {
        $ep_stmt = $db->prepare("SELECT MAX(episode) as max_ep FROM series WHERE imdb_id = ? AND season = ? AND quality = ? AND subtitle_dubbed = ?");
        $ep_stmt->bind_param("siss", $imdb_id, $season, $quality, $subtitle);
        
        $ep_stmt->execute();
        $new_episode = ($ep_stmt->get_result()->fetch_assoc()['max_ep'] ?? 0) + 1;
        $stmt = $db->prepare("INSERT INTO series (imdb_id, title, season, episode, quality, subtitle_dubbed, file_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssiisss", $imdb_id, $title, $season, $new_episode, $quality, $subtitle, $file_id); $stmt->execute();
        sendMessage($chat_id, "✅ فایل قسمت <code>$new_episode</code> فصل <code>$season</code> ذخیره شد. فایل بعدی یا /done");
    }

    if ($is_new_entry) {
        postToChannel($imdb_id);
    }
}

function handle_callback_query($chat_id, $user_id, $callback_query, $user_state) {
    global $db;
    $callback_data = $callback_query['data'];
    $parts = explode('_', $callback_data);
    $command = $parts[0] ?? '';
    $message_id = $callback_query['message']['message_id'];
    
    logMessage("Processing callback for user $user_id: $callback_data");
    
    if ($callback_data === 'start') {
        if(getSetting('is_membership_required') == '1' && !isMainAdmin($user_id)){
            if (checkMembership($user_id)) {
                deleteMessage($chat_id, $message_id); 
                handle_message($chat_id, $user_id, ['text' => '/start'], $user_state);
            } else {
                answerCallbackQuery($callback_query['id'], "شما هنوز در تمام کانال‌ها عضو نشده‌اید!", true);
            }
        } else {
            handle_message($chat_id, $user_id, ['text' => '/start'], $user_state);
        }
        return;
    }

    if (in_array($command, ['search', 'top', 'request', 'dlstart', 'dl', 'getfile', 'getall']) || ($command === 'confirm' && ($parts[1] ?? '') === 'request')) {
        handleUserCallback($chat_id, $user_id, $callback_data, $callback_query);
        return;
    }

    if (!isAdmin($user_id)) {
        answerCallbackQuery($callback_query['id'], "شما دسترسی لازم برای اینکار را ندارید.", true);
        return;
    }
    
    $cancel_button = ['text' => '🔙 انصراف و بازگشت به پنل', 'callback_data' => 'admin_panel'];
    
    if ($callback_data === 'admin_panel') {
        clearAdminContext($user_id);
        $keyboard = ['inline_keyboard' => [[['text' => '➕ افزودن فیلم', 'callback_data' => 'add_movie'], ['text' => '➕ افزودن سریال', 'callback_data' => 'add_series']], [['text' => '🗑 حذف محتوا', 'callback_data' => 'delete_content']], [['text' => '📈 آمار', 'callback_data' => 'stats'], ['text' => '📢 پیام همگانی', 'callback_data' => 'broadcast']]]];
        if (isMainAdmin($user_id)) {
            $mem_text = getSetting('is_membership_required') == '1' ? '🚫 غیرفعال کردن عضویت' : '✅ فعال کردن عضویت';
            $keyboard['inline_keyboard'][] = [['text' => '➕ افزودن ادمین', 'callback_data' => 'add_admin'], ['text' => '➖ حذف ادمین', 'callback_data' => 'remove_admin']];
            $keyboard['inline_keyboard'][] = [['text' => '📢 تنظیم کانال‌ها', 'callback_data' => 'set_channels'], ['text' => '📜 تنظیم تبلیغ', 'callback_data' => 'set_ad']];
            $keyboard['inline_keyboard'][] = [['text' => $mem_text, 'callback_data' => 'toggle_membership']];
        }
        
        $response = editMessage($chat_id, $message_id, "🛠 به پنل مدیریت خوش آمدید.", $keyboard);
        if(!$response || !$response['ok']) { logMessage("ERROR: editMessage failed for admin_panel. " . json_encode($response)); }
        return;
    }
    
    switch ($command) {
        case 'add': 
            $msg = "";
            if ($parts[1] == 'movie') { setAdminState($user_id, 2); $msg = "🎥 لینک IMDb فیلم را بفرستید:"; }
            elseif ($parts[1] == 'series') { setAdminState($user_id, 3); $msg = "📺 لینک IMDb سریال را بفرستید:"; }
            elseif ($parts[1] == 'new' && $parts[2] == 'season') { setAdminState($user_id, 6); $msg = "📺 شماره فصل جدید را وارد کنید:"; }
            elseif ($parts[1] == 'admin') { setAdminState($user_id, 10); $msg = "➕ آیدی عددی کاربر برای افزودن به ادمین‌ها را وارد کنید:"; }
            $response = editMessage($chat_id, $message_id, $msg, ['inline_keyboard' => [[$cancel_button]]]);
            if(!$response || !$response['ok']){ logMessage("Callback 'add' failed: ".json_encode($response)); }
            break;
        case 'remove': 
            if ($parts[1] == 'admin') { 
                setAdminState($user_id, 13);
                $response = editMessage($chat_id, $message_id, "➖ آیدی عددی ادمینی که می‌خواهید حذف کنید را وارد کنید:", ['inline_keyboard' => [[$cancel_button]]]); 
                if(!$response || !$response['ok']){ logMessage("Callback 'remove_admin' failed: ".json_encode($response)); }
            } 
            break;
        case 'delete': 
            if ($parts[1] == 'content') { 
                setAdminState($user_id, 14);
                $response = editMessage($chat_id, $message_id, "🗑 لینک IMDb محتوایی که قصد حذف کامل آن را دارید، ارسال کنید.", ['inline_keyboard' => [[$cancel_button]]]); 
                if(!$response || !$response['ok']){ logMessage("Callback 'delete_content' failed: ".json_encode($response)); }
            }
            break;
        case 'confirm':
            if ($parts[1] == 'delete' && $parts[2] == 'all' && $parts[3] == 'prompt'){
                $imdb_id = $parts[4];
                $kb = [ 'inline_keyboard' => [
                    [['text' => '❌ بله، مطمئنم. حذف کن!', 'callback_data' => "confirm_delete_all_final_{$imdb_id}"]],
                    [$cancel_button]
                ]];
                editMessage($chat_id, $message_id, "⚠️ آیا از حذف تمام فایل‌های مرتبط با <code>$imdb_id</code> مطمئن هستید؟ این عملیات غیرقابل بازگشت است.", $kb);
            }
            elseif ($parts[1] == 'delete' && $parts[2] == 'all' && $parts[3] == 'final') { 
                $imdb_id = $parts[4];
                $count = deleteContentByImdbId($imdb_id);
                editMessage($chat_id, $message_id, "✅ عملیات با موفقیت انجام شد. $count رکورد برای <code>$imdb_id</code> حذف گردید.");
                clearAdminContext($user_id);
            }
            break;
        case 'pdel':
            handlePartialDelete($chat_id, $message_id, $parts, $cancel_button);
            break;
        case 'set': 
            if ($parts[1] == 'channels') { 
                setAdminState($user_id, 4); 
                $ch = getChannelList(); 
                $message = "لیست کانال‌ها:\n" . (empty($ch) ? "خالی" : implode("\n", $ch)); 
                $message .= "\n\nبرای افزودن/حذف، آیدی کانال با @ را بفرستید. برای اتمام، /done را ارسال کنید."; 
                editMessage($chat_id, $message_id, $message); 
            } elseif ($parts[1] == 'ad') { 
                setAdminState($user_id, 5); 
                $message = "لطفا متن تبلیغ را ارسال کنید. برای حذف تبلیغ، /no_ad را بفرستید.\n\n"
                          . "<b>تبلیغات پیشرفته با دکمه:</b>\n"
                          . "متن خود را بنویسید، سپس --- را در خط جدید وارد کرده و در ادامه ساختار دکمه‌ها را به صورت JSON قرار دهید.\n"
                          . "مثال:\n"
                          . "<code>این یک تبلیغ است</code>\n"
                          . "<code>---</code>\n"
                          . "<code>[[{\"text\":\"گوگل\", \"url\":\"https://google.com\"}]]</code>";
                editMessage($chat_id, $message_id, $message, ['inline_keyboard' => [[$cancel_button]]]); 
            } 
            break;
        case 'toggle': 
            if ($parts[1] == 'membership') { 
                $n = getSetting('is_membership_required') == '1' ? '0' : '1'; 
                updateSetting('is_membership_required', $n); 
                $message = "✅ عضویت اجباری " . ($n == '1' ? "فعال" : "غیرفعال") . " شد."; 
                answerCallbackQuery($callback_query['id'], $message);
                $callback_query['data'] = 'admin_panel';
                handle_callback_query($chat_id, $user_id, $callback_query, $user_state);
            } 
            break;
        case 'stats': 
            $s = getStats(); 
            $message = "📊 <b>آمار ربات</b>\n\n👥 کاربران: {$s['users']}\n📥 دانلودها: {$s['downloads']}\n🎥 فیلم‌ها: {$s['movies']}\n📺 سریال‌ها: {$s['series']}\n📩 درخواست‌ها: {$s['requests']}"; 
            editMessage($chat_id, $message_id, $message, ['inline_keyboard' => [[$cancel_button]]]);
            break;
        case 'broadcast': 
            setAdminState($user_id, 8); 
            editMessage($chat_id, $message_id, "📢 پیام همگانی را وارد کنید:", ['inline_keyboard' => [[$cancel_button]]]); 
            break;
        case 'season':
            $context = getAdminContext($user_id);
            $season_num = intval($parts[1]); setAdminContext($user_id, $context['admin_context_imdb'], $season_num);
            $keyboard_rows = generateDynamicQualityKeyboard($context['admin_context_imdb'], $season_num);
            $keyboard_rows[] = [['text' => '➕ کیفیت جدید', 'callback_data' => 'quality_custom']];
            $keyboard_rows[] = [['text' => '🔙 بازگشت', 'callback_data' => 'add_series']];
            $keyboard_rows[] = [$cancel_button];
            $kb = ['inline_keyboard' => $keyboard_rows];
            editMessage($chat_id, $message_id, "✅ فصل $season_num انتخاب شد. کیفیت را انتخاب کنید:", $kb);
            break;
        case 'quality':
            $context = getAdminContext($user_id);
            if ($callback_data === 'quality_custom') {
                setAdminState($user_id, 7);
                editMessage($chat_id, $message_id, "لطفا نام کیفیت جدید را وارد کنید (مثال: 1080p WEB-DL):", ['inline_keyboard' => [[$cancel_button]]]);
                return;
            }
            $quality = str_replace('quality_', '', $callback_data);
            setAdminContext($user_id, $context['admin_context_imdb'], $context['admin_context_season'], $quality);
            $back_cb = is_null($context['admin_context_season']) ? 'add_movie' : 'season_' . $context['admin_context_season'];
            $kb = [ 'inline_keyboard' => [
                    [['text' => '📝 زیرنویس' . (in_array('subtitle', getExistingSubtypesForQuality($context['admin_context_imdb'], $context['admin_context_season'], $quality)) ? ' 🌟' : ''), 'callback_data' => 'subtitle_subtitle']],
                    [['text' => '🎙 دوبله فارسی' . (in_array('dubbed', getExistingSubtypesForQuality($context['admin_context_imdb'], $context['admin_context_season'], $quality)) ? ' 🌟' : ''), 'callback_data' => 'subtitle_dubbed']],
                    [['text' => '📁 فایل اصلی' . (in_array('', getExistingSubtypesForQuality($context['admin_context_imdb'], $context['admin_context_season'], $quality)) ? ' 🌟' : ''), 'callback_data' => 'subtitle_none']],
                    [['text' => '🔙 بازگشت به انتخاب کیفیت', 'callback_data' => $back_cb]],
                    [$cancel_button]
                ]];
            editMessage($chat_id, $message_id, "✅ کیفیت <code>" . htmlspecialchars($quality) . "</code> انتخاب شد. نوع فایل را مشخص کنید:", $kb);
            break;
        case 'subtitle':
            $context = getAdminContext($user_id);
            $subtitle_type = ($parts[1] == 'none') ? '' : $parts[1];
            setAdminContext($user_id, $context['admin_context_imdb'], $context['admin_context_season'], $context['admin_context_quality'], $subtitle_type);
            editMessage($chat_id, $message_id, "✅ بسیار خب! اکنون فایل(ها) را ارسال کنید. پس از اتمام، /done را تایپ کنید.", ['inline_keyboard' => [[$cancel_button]]]);
            break;
        case 'reupload':
            $imdb_id = $parts[1] ?? null;
            $season = ($parts[2] == 'movie' || empty($parts[2])) ? null : intval($parts[2]);
            if ($imdb_id) {
                setAdminContext($user_id, $imdb_id, $season);
                $keyboard_rows = generateDynamicQualityKeyboard($imdb_id, $season);
                $keyboard_rows[] = [['text' => '➕ کیفیت جدید', 'callback_data' => 'quality_custom']];
                $keyboard_rows[] = [$cancel_button];
                $kb = ['inline_keyboard' => $keyboard_rows];
                editMessage($chat_id, $message_id, "✅ برای آپلود مجدد، کیفیت جدید را انتخاب کنید:", $kb);
            }
            break;
    }
}

function handlePartialDelete($chat_id, $message_id, $parts, $cancel_button) {
    global $db;
    $step = $parts[1];
    
    if ($step == 'start') {
        $imdb_id = $parts[2];
        $movie_exists = $db->query("SELECT id FROM movies WHERE imdb_id = '$imdb_id'")->num_rows > 0;
        $series_exists = $db->query("SELECT id FROM series WHERE imdb_id = '$imdb_id'")->num_rows > 0;
        $keyboard = [];
        
        if ($series_exists) {
            $stmt = $db->prepare("SELECT DISTINCT season FROM series WHERE imdb_id = ? ORDER BY season ASC");
            $stmt->bind_param("s", $imdb_id); $stmt->execute();
            $seasons = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            foreach ($seasons as $season) {
                $keyboard[] = [['text' => '🗓 فصل ' . $season['season'], 'callback_data' => "pdel_series_type_{$imdb_id}_{$season['season']}"]];
            }
        } elseif ($movie_exists) {
            $stmt = $db->prepare("SELECT id, quality, subtitle_dubbed FROM movies WHERE imdb_id = ?");
            $stmt->bind_param("s", $imdb_id); $stmt->execute();
            $files = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            foreach ($files as $item) {
                $sub_text = $item['subtitle_dubbed'] == 'subtitle' ? 'زیرنویس' : ($item['subtitle_dubbed'] == 'dubbed' ? 'دوبله فارسی' : 'اصلی');
                $keyboard[] = [['text' => "{$item['quality']} - {$sub_text}", 'callback_data' => "pdel_movie_confirm_{$item['id']}"]];
            }
        }
        $keyboard[] = [$cancel_button];
        editMessage($chat_id, $message_id, 'مورد مورد نظر برای حذف را انتخاب کنید:', ['inline_keyboard' => $keyboard]);
        return;
    }
    
    $type = $parts[1];
    $actual_step = $parts[2];
    $keyboard = [];
    $message = "";

    if($type == 'series'){
        $imdb_id = $parts[3]; $season = $parts[4];
        if($actual_step == 'type'){
             $stmt = $db->prepare("SELECT DISTINCT subtitle_dubbed FROM series WHERE imdb_id = ? AND season = ?");
             $stmt->bind_param("si", $imdb_id, $season); $stmt->execute();
             $subtitles = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
             foreach ($subtitles as $item) {
                 $sub_text = $item['subtitle_dubbed'] == 'subtitle' ? '📝 زیرنویس' : ($item['subtitle_dubbed'] == 'dubbed' ? '🎙 دوبله فارسی' : '📁 اصلی');
                 $keyboard[] = [['text' => $sub_text, 'callback_data' => "pdel_series_quality_{$imdb_id}_{$season}_{$item['subtitle_dubbed']}"]];
             }
             $message = "نوع فایل را برای حذف انتخاب کنید:";
        }
        elseif($actual_step == 'quality'){
            $subtitle_type = $parts[5];
            $stmt = $db->prepare("SELECT DISTINCT quality FROM series WHERE imdb_id = ? AND season = ? AND subtitle_dubbed = ?");
            $stmt->bind_param("sis", $imdb_id, $season, $subtitle_type); $stmt->execute();
            $qualities = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            foreach($qualities as $item) {
                $keyboard[] = [['text' => '🖥 ' . $item['quality'], 'callback_data' => "pdel_series_episode_{$imdb_id}_{$season}_{$subtitle_type}_{$item['quality']}"]];
            }
             $message = "کیفیت را برای حذف انتخاب کنید:";
        }
        elseif($actual_step == 'episode'){
            $subtitle_type = $parts[5]; $quality = $parts[6];
            $stmt = $db->prepare("SELECT id, episode FROM series WHERE imdb_id = ? AND season = ? AND subtitle_dubbed = ? AND quality = ? ORDER BY episode ASC");
            $stmt->bind_param("siss", $imdb_id, $season, $subtitle_type, $quality); $stmt->execute();
            $episodes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            $episode_buttons = [];
            foreach ($episodes as $ep) {
                $episode_buttons[] = ['text' => '📂 قسمت ' . $ep['episode'], 'callback_data' => "pdel_series_confirm_{$ep['id']}"];
            }
            $keyboard = array_chunk($episode_buttons, 2);
             $message = "قسمت مورد نظر برای حذف را انتخاب کنید:";
        }
        elseif($actual_step == 'confirm'){
            $record_id = $parts[3];
            $keyboard = [[['text' => '❌ بله، حذف کن', 'callback_data' => "pdel_series_final_{$record_id}"]]];
            $message = "آیا از حذف این فایل مطمئن هستید؟";
        }
        elseif($actual_step == 'final'){
            $record_id = $parts[3];
            $stmt = $db->prepare("DELETE FROM series WHERE id = ?");
            $stmt->bind_param("i", $record_id); $stmt->execute();
            $message = "✅ فایل با موفقیت حذف شد.";
            editMessage($chat_id, $message_id, $message, null);
            return;
        }
    }
    elseif($type == 'movie'){
        if($actual_step == 'confirm'){
            $record_id = $parts[3];
            $keyboard = [[['text' => '❌ بله، حذف کن', 'callback_data' => "pdel_movie_final_{$record_id}"]]];
            $message = "آیا از حذف این فایل مطمئن هستید؟";
        }
        elseif($actual_step == 'final'){
            $record_id = $parts[3];
            $stmt = $db->prepare("DELETE FROM movies WHERE id = ?");
            $stmt->bind_param("i", $record_id); $stmt->execute();
            $message = "✅ فایل با موفقیت حذف شد.";
            editMessage($chat_id, $message_id, $message, null);
            return;
        }
    }

    $keyboard[] = [$cancel_button];
    editMessage($chat_id, $message_id, $message, ['inline_keyboard' => $keyboard]);
}
?>