<?php
// functions.php
require_once 'config.php';

function logMessage($message) { if (defined('LOG_FILE') && is_writable(dirname(LOG_FILE))) { file_put_contents(LOG_FILE, date('Y-m-d H:i:s') . ' - ' . $message . PHP_EOL, FILE_APPEND); } }

function sendMessage($chat_id, $text, $reply_markup = null) {
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    $ch = curl_init(API_URL . 'sendMessage');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function editMessage($chat_id, $message_id, $text, $reply_markup = null) {
    $data = ['chat_id' => $chat_id, 'message_id' => $message_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    $ch = curl_init(API_URL . 'editMessageText');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function pinChatMessage($chat_id, $message_id) {
    $data = ['chat_id' => $chat_id, 'message_id' => $message_id, 'disable_notification' => true];
    $ch = curl_init(API_URL . 'pinChatMessage');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    curl_exec($ch);
    curl_close($ch);
}

function unpinChatMessage($chat_id, $message_id) {
    $data = ['chat_id' => $chat_id, 'message_id' => $message_id];
    $ch = curl_init(API_URL . 'unpinChatMessage');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    curl_exec($ch);
    curl_close($ch);
}


function sendVideo($chat_id, $file_id, $caption = '', $reply_to_message_id = null) {
    $data = ['chat_id' => $chat_id, 'video' => $file_id, 'caption' => $caption, 'parse_mode' => 'HTML'];
    if ($reply_to_message_id) {
        $data['reply_to_message_id'] = $reply_to_message_id;
    }
    $ch = curl_init(API_URL . 'sendVideo');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => $data, CURLOPT_RETURNTRANSFER => true]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function deleteMessage($chat_id, $message_id) {
    $data = ['chat_id' => $chat_id, 'message_id' => $message_id];
    $ch = curl_init(API_URL . 'deleteMessage');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    curl_exec($ch);
    curl_close($ch);
}

function answerCallbackQuery($callback_query_id, $text, $show_alert = false) {
    $data = ['callback_query_id' => $callback_query_id, 'text' => $text, 'show_alert' => $show_alert];
    $ch = curl_init(API_URL . 'answerCallbackQuery');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    curl_exec($ch);
    curl_close($ch);
}

function sendPhoto($chat_id, $photo_url, $caption, $reply_markup = null) {
    $data = ['chat_id' => $chat_id, 'photo' => $photo_url, 'caption' => $caption, 'parse_mode' => 'HTML'];
    if ($reply_markup) {
        $data['reply_markup'] = json_encode($reply_markup);
    }
    $ch = curl_init(API_URL . 'sendPhoto');
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function getChatMember($chat_id, $user_id) { $data = ['chat_id' => $chat_id, 'user_id' => $user_id]; $ch = curl_init(API_URL . 'getChatMember'); curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($data), CURLOPT_RETURNTRANSFER => true]); $response = curl_exec($ch); curl_close($ch); return json_decode($response, true); }

function getIMDbInfo($imdb_id) {
    // ... Function remains the same as the last correct version
    logMessage("Attempting to fetch IMDb info for ID: " . $imdb_id);
    if (!defined('IMDB_API_KEY') || empty(IMDB_API_KEY)) {
        logMessage("IMDB_API_KEY is not defined or empty. Cannot fetch IMDb info.");
        return false;
    }
    $url = "http://www.omdbapi.com/?i=" . urlencode($imdb_id) . "&apikey=" . IMDB_API_KEY . "&plot=full";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    $response = curl_exec($ch);
    if (curl_errno($ch)) { logMessage("cURL Error fetching OMDb: " . curl_error($ch)); curl_close($ch); return false; }
    curl_close($ch);
    $data = json_decode($response, true);
    if (isset($data['Response']) && $data['Response'] == 'True') {
        $rotten_tomatoes = 'N/A';
        $metacritic = 'N/A';
        if (isset($data['Ratings']) && is_array($data['Ratings'])) {
            foreach ($data['Ratings'] as $rating) {
                if ($rating['Source'] === 'Rotten Tomatoes') { $rotten_tomatoes = $rating['Value']; }
                if ($rating['Source'] === 'Metacritic') { $metacritic = $rating['Value']; }
            }
        }
        $high_quality_poster = '';
        if (isset($data['Poster']) && $data['Poster'] !== 'N/A') {
            $high_quality_poster = preg_replace('/_V1_.*\.jpg$/', '_V1_.jpg', $data['Poster']);
        }
        return [
            'title' => $data['Title'] ?? 'نامشخص', 'year' => $data['Year'] ?? 'نامشخص', 'plot' => $data['Plot'] ?? 'خلاصه داستان نامشخص',
            'genre' => $data['Genre'] ?? 'ژانر نامشخص', 'actors' => $data['Actors'] ?? 'بازیگران نامشخص', 'director' => $data['Director'] ?? 'نامشخص',
            'poster' => $high_quality_poster, 'rating' => $data['imdbRating'] ?? 'N/A', 'country' => $data['Country'] ?? 'نامشخص',
            'type' => $data['Type'] ?? 'movie', 'rotten_tomatoes' => $rotten_tomatoes, 'metacritic' => $metacritic
        ];
    }
    return false;
}

function format_quality_name($quality) {
    if (is_numeric($quality)) {
        return $quality . 'p';
    }
    // For qualities like '720p.x265', avoid adding another 'p'
    if (preg_match('/^\d+p/i', $quality)) {
        return $quality;
    }
    return $quality;
}

function generateDynamicQualityKeyboard($imdb_id, $season = null) {
    global $db;
    // Standard qualities that are always offered as an option
    $standard_qualities = ['480', '720', '1080', '1080_x265'];
    
    // Get qualities that already exist for THIS specific movie/series
    $existing_for_this_content = getExistingQualitiesForContent($imdb_id, $season);
    
    // Combine standard and existing qualities, ensuring no duplicates
    $all_possible_qualities = array_unique(array_merge($standard_qualities, $existing_for_this_content));
    
    $buttons = [];
    foreach ($all_possible_qualities as $quality_db_val) {
        $display_text = format_quality_name($quality_db_val);
        if (in_array($quality_db_val, $existing_for_this_content)) {
            $display_text .= ' 🌟'; // Mark existing qualities
        }
        $buttons[] = ['text' => '🖥 ' . $display_text, 'callback_data' => 'quality_' . $quality_db_val];
    }
    return array_chunk($buttons, 2);
}

// Other helper functions like isAdmin, setAdminState, etc. remain the same.
function extractIMDbID($text, $entities = []) { if (preg_match('/(tt\d{7,10})/', $text, $matches)) { return $matches[1]; } if (is_array($entities)) { foreach ($entities as $entity) { if ($entity['type'] === 'text_link' && isset($entity['url']) && preg_match('/(tt\d{7,10})/', $entity['url'], $matches)) { return $matches[1]; } if ($entity['type'] === 'url' && preg_match('/(tt\d{7,10})/', substr($text, $entity['offset'], $entity['length']), $matches)) { return $matches[1]; } } } return null; }
function isAdmin($user_id) { global $db; if (in_array((string)$user_id, ADMIN_IDS)) return true; $stmt = $db->prepare("SELECT is_admin FROM users WHERE user_id = ? AND is_admin >= 1"); if(!$stmt) return false; $stmt->bind_param("i", $user_id); $stmt->execute(); return $stmt->get_result()->num_rows > 0; }
function isMainAdmin($user_id) { return in_array((string)$user_id, ADMIN_IDS); }
function setAdminState($user_id, $state) { logMessage("Attempting to set state for user $user_id to: $state"); global $db; $stmt = $db->prepare("UPDATE users SET is_admin = ? WHERE user_id = ?"); $stmt->bind_param("ii", $state, $user_id); $stmt->execute(); if($stmt->affected_rows > 0){ logMessage("State successfully updated for user $user_id to $state."); } else { logMessage("State update failed or no change for user $user_id (state: $state). Error: " . $stmt->error); } }
function setAdminContext($user_id, $imdb_id = null, $season = null, $quality = null, $subtitle = null) { global $db; $stmt = $db->prepare("UPDATE users SET admin_context_imdb = ?, admin_context_season = ?, admin_context_quality = ?, admin_context_subtitle = ? WHERE user_id = ?"); $stmt->bind_param("sissi", $imdb_id, $season, $quality, $subtitle, $user_id); $stmt->execute(); }
function getAdminContext($user_id) { global $db; $stmt = $db->prepare("SELECT admin_context_imdb, admin_context_season, admin_context_quality, admin_context_subtitle FROM users WHERE user_id = ?"); $stmt->bind_param("i", $user_id); $stmt->execute(); return $stmt->get_result()->fetch_assoc(); }
function clearAdminContext($user_id) { setAdminContext($user_id); if (isAdmin($user_id)) { if (isMainAdmin($user_id)) { setAdminState($user_id, 99); } else { setAdminState($user_id, 1); } } }
function deleteContentByImdbId($imdb_id) { global $db; $stmt_movies = $db->prepare("DELETE FROM movies WHERE imdb_id = ?"); $stmt_movies->bind_param("s", $imdb_id); $m_deleted = $stmt_movies->execute() ? $stmt_movies->affected_rows : 0; $stmt_series = $db->prepare("DELETE FROM series WHERE imdb_id = ?"); $stmt_series->bind_param("s", $imdb_id); $s_deleted = $stmt_series->execute() ? $stmt_series->affected_rows : 0; return $m_deleted + $s_deleted; }
function postToChannel($imdb_id) { if (!defined('POST_CHANNEL_ID') || empty(POST_CHANNEL_ID)) return; $info = getIMDbInfo($imdb_id); if (!$info) return; $year = $info['year'] ?? ''; $bot_link = 'https://t.me/'.BOT_USERNAME; $caption = "🎬 <b>{$info['title']} [{$year}]</b>\n"; $caption .= "➖➖➖➖➖➖\n"; $caption .= "┣⭐️ IMDb: {$info['rating']}/10\n"; if ($info['type'] === 'movie') { $caption .= "┣🍅 Rotten Tomatoes: {$info['rotten_tomatoes']}\n"; $caption .= "┣Ⓜ️ Metacritic: {$info['metacritic']}\n"; } $caption .= "┣🌍: {$info['country']}\n"; $caption .= "➖➖➖➖➖➖\n"; $caption .= "🎭 <b>ژانر:</b> {$info['genre']}\n"; if ($info['type'] === 'movie') { $caption .= "🎬 <b>کارگردان:</b> {$info['director']}\n"; } $caption .= "👥 <b>بازیگران:</b> {$info['actors']}\n\n"; $caption .= "📝 <b>خلاصه داستان:</b>\n<i>{$info['plot']}</i>\n\n"; $caption .= "🍿 <a href=\"{$bot_link}\">سینما گریت | Cinema Great</a>"; $keyboard = ['inline_keyboard' => [[['text' => '📥دانلود📥', 'url' => 'https://t.me/' . BOT_USERNAME . "?start=$imdb_id"]]]]; $photo_url = $info['poster'] ?? ''; $response = sendPhoto(POST_CHANNEL_ID, $photo_url, $caption, $keyboard); if (!$response || !$response['ok']) { logMessage("postToChannel: sendPhoto failed. Falling back to sendMessage. Response: " . json_encode($response)); sendMessage(POST_CHANNEL_ID, $caption, $keyboard); } }
function getExistingQualitiesForContent($imdb_id, $season = null) { global $db; $existing = []; $table = is_null($season) ? 'movies' : 'series'; $sql = "SELECT DISTINCT quality FROM {$table} WHERE imdb_id = ?"; if (!is_null($season)) { $sql .= " AND season = ?"; $stmt = $db->prepare($sql); $stmt->bind_param("si", $imdb_id, $season); } else { $stmt = $db->prepare($sql); $stmt->bind_param("s", $imdb_id); } if ($stmt && $stmt->execute()) { $result = $stmt->get_result(); while ($row = $result->fetch_assoc()) { $existing[] = $row['quality']; } } return $existing; }
function getExistingSubtypesForQuality($imdb_id, $season, $quality) { global $db; $existing = []; $table = is_null($season) ? 'movies' : 'series'; if (is_null($season)) { $stmt = $db->prepare("SELECT DISTINCT subtitle_dubbed FROM movies WHERE imdb_id = ? AND quality = ?"); $stmt->bind_param("ss", $imdb_id, $quality); } else { $stmt = $db->prepare("SELECT DISTINCT subtitle_dubbed FROM series WHERE imdb_id = ? AND season = ? AND quality = ?"); $stmt->bind_param("sis", $imdb_id, $season, $quality); } if ($stmt && $stmt->execute()) { $result = $stmt->get_result(); while ($row = $result->fetch_assoc()) { $existing[] = $row['subtitle_dubbed']; } } return $existing; }
function getAdditionalAdmins() { global $db; $main_admins_str = "'" . implode("','", ADMIN_IDS) . "'"; $result = $db->query("SELECT user_id FROM users WHERE is_admin >= 1 AND user_id NOT IN ($main_admins_str)"); return $result ? array_column($result->fetch_all(MYSQLI_ASSOC), 'user_id') : []; }
function getSetting($key) { global $db; $stmt = $db->prepare("SELECT setting_value FROM settings WHERE setting_key = ?"); $stmt->bind_param("s", $key); $stmt->execute(); return $stmt->get_result()->fetch_assoc()['setting_value'] ?? ''; }
function updateSetting($key, $value) { global $db; $stmt = $db->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?"); $stmt->bind_param("sss", $key, $value, $value); $stmt->execute(); }
function getChannelList() { $channels = getSetting('ad_channels'); return empty($channels) ? [] : array_map('trim', explode(',', $channels)); }
function addChannel($channel) { $channels = getChannelList(); if (!in_array($channel, $channels)) { $channels[] = $channel; updateSetting('ad_channels', implode(',', $channels)); } }
function removeChannel($channel) { $channels = array_filter(getChannelList(), fn($ch) => $ch !== $channel); updateSetting('ad_channels', implode(',', $channels)); }
function getStats() { global $db; return ['users' => $db->query("SELECT COUNT(*) as c FROM users")->fetch_assoc()['c'] ?? 0, 'downloads' => $db->query("SELECT COUNT(*) as c FROM downloads")->fetch_assoc()['c'] ?? 0, 'requests' => $db->query("SELECT COUNT(*) as c FROM requests")->fetch_assoc()['c'] ?? 0, 'movies' => $db->query("SELECT COUNT(DISTINCT imdb_id) as c FROM movies")->fetch_assoc()['c'] ?? 0, 'series' => $db->query("SELECT COUNT(DISTINCT imdb_id) as c FROM series")->fetch_assoc()['c'] ?? 0, ]; }
function checkMembership($user_id) { $channels = getChannelList(); if (empty($channels)) return true; foreach ($channels as $channel) { $result = getChatMember($channel, $user_id); if (!$result || ($result['ok'] === false)) { logMessage("Could not check membership for user $user_id in channel $channel. Error: " . ($result['description'] ?? 'Unknown')); return false; } $status = $result['result']['status'] ?? 'left'; if (!in_array($status, ['member', 'administrator', 'creator'])) { return false; } } return true; }
?>