<?php
// user_panel.php
function handleUserInput($chat_id, $user_id, $message_text, $entities = []) {
    global $db;

    // This handles both direct imdb_id from /start and links from messages
    $imdb_id = extractIMDbID($message_text, $entities);
    
    if(!$imdb_id) {
        $search_guide_text = "❌ لینک معتبری یافت نشد.\n\n"
                           . "برای جستجوی فیلم و سریال، از ربات جستجوگر زیر در همین چت استفاده کنید:\n"
                           . "1. `@imdbot` را تایپ کنید.\n"
                           . "2. یک فاصله بگذارید و نام فیلم را بنویسید.\n"
                           . "3. از لیست نتایج، مورد دلخواه را انتخاب کنید تا اطلاعات آن به ربات ارسال شود.";
        sendMessage($chat_id, $search_guide_text);
        return;
    }

    $imdb_info = getIMDbInfo($imdb_id);
    if (!$imdb_info) { sendMessage($chat_id, "❌ اطلاعاتی برای این لینک یافت نشد."); return; }

    $movie_exists = $db->query("SELECT id FROM movies WHERE imdb_id = '$imdb_id'")->num_rows > 0;
    $series_exists = $db->query("SELECT id FROM series WHERE imdb_id = '$imdb_id'")->num_rows > 0;
    
    $year = $imdb_info['year'] ?? '';
    $bot_link = 'https://t.me/'.BOT_USERNAME;

    $caption = "🎬 <b>{$imdb_info['title']} [{$year}]</b>\n";
    $caption .= "➖➖➖➖➖➖\n";
    $caption .= "┣⭐️ IMDb: {$imdb_info['rating']}/10\n";
    
    if ($imdb_info['type'] === 'movie') {
        $caption .= "┣🍅 Rotten Tomatoes: {$imdb_info['rotten_tomatoes']}\n";
        $caption .= "┣Ⓜ️ Metacritic: {$imdb_info['metacritic']}\n";
    }

    $caption .= "┣🌍: {$imdb_info['country']}\n";
    $caption .= "➖➖➖➖➖➖\n";
    $caption .= "🎭 <b>ژانر:</b> {$imdb_info['genre']}\n";

    if ($imdb_info['type'] === 'movie') {
        $caption .= "🎬 <b>کارگردان:</b> {$imdb_info['director']}\n";
    }

    $caption .= "👥 <b>بازیگران:</b> {$imdb_info['actors']}\n\n";
    $caption .= "📝 <b>خلاصه داستان:</b>\n<i>{$imdb_info['plot']}</i>\n\n";
    $caption .= "🍿 <a href=\"{$bot_link}\">سینما گریت | Cinema Great</a>";

    if ($movie_exists || $series_exists) {
        $type = $movie_exists ? 'movie' : 'series';
        $keyboard = ['inline_keyboard' => [[['text' => '📥دانلود📥', 'callback_data' => "dlstart_{$type}_{$imdb_id}"]]]];
    } else {
        $keyboard = ['inline_keyboard' => [[['text' => '📩 درخواست به ادمین‌ها', 'callback_data' => 'request_' . $imdb_id]]]];
        $caption .= "\n\n⚠️ این عنوان در آرشیو ربات موجود نیست.";
    }
    
    $photo_url = $imdb_info['poster'] ?? '';
    $response = sendPhoto($chat_id, $photo_url, $caption, $keyboard);
    if (!$response || !$response['ok']) {
        logMessage("handleUserInput: sendPhoto failed. Falling back to sendMessage. Response: " . json_encode($response));
        sendMessage($chat_id, $caption, $keyboard);
    }
    
    $ad = getSetting('ad_message');
    if (!empty($ad)) {
        $ad_parts = explode('---', $ad, 2);
        $ad_text = trim($ad_parts[0]);
        $ad_keyboard = null;
        if (isset($ad_parts[1])) {
            $keyboard_data = json_decode(trim($ad_parts[1]), true);
            if (is_array($keyboard_data)) {
                $ad_keyboard = ['inline_keyboard' => $keyboard_data];
            }
        }
        sendMessage($chat_id, $ad_text, $ad_keyboard);
    }
}

function handleUserCallback($chat_id, $user_id, $callback_data, $callback_query) {
    global $db;
    $parts = explode('_', $callback_data);
    $command = $parts[0] ?? '';
    $message_id = $callback_query['message']['message_id'];
    $footer_caption = "\n\nربات سینما گریت بهترین ربات فیلم و سریال\n🎞 @" . BOT_USERNAME;

    switch ($command) {
        case 'search':
            sendMessage($chat_id, "🔎 برای جستجوی فیلم یا سریال، در همین صفحه `@imdbot` را تایپ کرده و سپس نام فیلم را وارد کنید.");
            break;

        case 'top':
            if (($parts[1] ?? '') == 'downloads') {
                $query = "SELECT title, COUNT(*) as count FROM downloads WHERE download_time >= NOW() - INTERVAL 7 DAY AND title IS NOT NULL AND title != '' GROUP BY title ORDER BY count DESC LIMIT 10";
                $res = $db->query($query);
                $top_downloads = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
                $text = empty($top_downloads) ? "در هفته اخیر دانلودی ثبت نشده است." : "🔥 <b>پردانلودترین‌های هفته:</b>\n\n";
                if (!empty($top_downloads)) {
                    $i = 1;
                    foreach ($top_downloads as $item) {
                        $text .= "$i. {$item['title']}\n";
                        $i++;
                    }
                }
                sendMessage($chat_id, $text, ['inline_keyboard' => [[['text' => '🔙 بازگشت', 'callback_data' => 'start']]]]);
            }
            break;

        case 'dlstart':
            $type = $parts[1];
            $imdb_id = $parts[2];
            
            $sent_message = sendMessage($chat_id, '⏳ در حال بارگذاری...');
            if (!$sent_message || !isset($sent_message['result']['message_id'])) {
                return;
            }
            $new_message_id = $sent_message['result']['message_id'];
            $keyboard = [];
            $text = '';
            
            if ($type == 'series') {
                $text = 'لطفا فصل را انتخاب کنید:';
                $stmt = $db->prepare("SELECT DISTINCT season FROM series WHERE imdb_id = ? ORDER BY season ASC");
                $stmt->bind_param("s", $imdb_id);
                $stmt->execute();
                $seasons = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                foreach ($seasons as $season) {
                    $keyboard[] = [['text' => '🗓 فصل ' . $season['season'], 'callback_data' => "dl_series_type_{$imdb_id}_{$season['season']}_{$new_message_id}"]];
                }
            } else { 
                $text = "لطفا نوع فایل را انتخاب کنید:";
                $stmt = $db->prepare("SELECT DISTINCT subtitle_dubbed FROM movies WHERE imdb_id = ?");
                $stmt->bind_param("s", $imdb_id);
                $stmt->execute();
                $subtitles = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                foreach ($subtitles as $item) {
                    $sub_text = $item['subtitle_dubbed'] == 'subtitle' ? '📝 زیرنویس' : ($item['subtitle_dubbed'] == 'dubbed' ? '🎙 دوبله فارسی' : '📁 اصلی');
                    $keyboard[] = [['text' => $sub_text, 'callback_data' => "dl_movie_quality_{$imdb_id}_{$item['subtitle_dubbed']}_{$new_message_id}"]];
                }
            }
            editMessage($chat_id, $new_message_id, $text, ['inline_keyboard' => $keyboard]);
            break;

        case 'dl':
            $type = $parts[1];
            $step = $parts[2];
            
            if ($type == 'series') {
                $imdb_id = $parts[3];
                $message_id_to_edit = end($parts);
                $back_to_seasons_cb = "dl_series_seasons_{$imdb_id}_{$message_id_to_edit}";
                
                if ($step == 'seasons'){
                     $stmt = $db->prepare("SELECT DISTINCT season FROM series WHERE imdb_id = ? ORDER BY season ASC");
                     $stmt->bind_param("s", $imdb_id);
                     $stmt->execute();
                     $seasons = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                     $keyboard = [];
                     foreach ($seasons as $season) {
                         $keyboard[] = [['text' => '🗓 فصل ' . $season['season'], 'callback_data' => "dl_series_type_{$imdb_id}_{$season['season']}_{$message_id_to_edit}"]];
                     }
                     editMessage($chat_id, $message_id_to_edit, 'لطفا فصل را انتخاب کنید:', ['inline_keyboard' => $keyboard]);
                     break;
                }

                $season = $parts[4];
                $back_to_filetype_cb = "dl_series_type_{$imdb_id}_{$season}_{$message_id_to_edit}";

                if ($step == 'type') {
                    $stmt = $db->prepare("SELECT DISTINCT subtitle_dubbed FROM series WHERE imdb_id = ? AND season = ?");
                    $stmt->bind_param("si", $imdb_id, $season);
                    $stmt->execute();
                    $subtitles = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                    $keyboard = [];
                    foreach ($subtitles as $item) {
                        $sub_text = $item['subtitle_dubbed'] == 'subtitle' ? '📝 زیرنویس' : ($item['subtitle_dubbed'] == 'dubbed' ? '🎙 دوبله فارسی' : '📁 اصلی');
                        $keyboard[] = [['text' => $sub_text, 'callback_data' => "dl_series_quality_{$imdb_id}_{$season}_{$item['subtitle_dubbed']}_{$message_id_to_edit}"]];
                    }
                    $keyboard[] = [['text' => '🔙 بازگشت به لیست فصل‌ها', 'callback_data' => $back_to_seasons_cb]];
                    editMessage($chat_id, $message_id_to_edit, "نوع فایل را انتخاب کنید:", ['inline_keyboard' => $keyboard]);
                
                } elseif ($step == 'quality') {
                    $subtitle_type = $parts[5];
                    $stmt = $db->prepare("SELECT DISTINCT quality FROM series WHERE imdb_id = ? AND season = ? AND subtitle_dubbed = ?");
                    $stmt->bind_param("sis", $imdb_id, $season, $subtitle_type);
                    $stmt->execute();
                    $qualities = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                    $keyboard = [];
                    foreach($qualities as $item) {
                        $keyboard[] = [['text' => '🖥 ' . format_quality_name($item['quality']), 'callback_data' => "dl_series_episode_{$imdb_id}_{$season}_{$subtitle_type}_{$item['quality']}_{$message_id_to_edit}"]];
                    }
                    $keyboard[] = [['text' => '🔙 بازگشت به نوع فایل', 'callback_data' => $back_to_filetype_cb]];
                    $keyboard[] = [['text' => '🔙 بازگشت به لیست فصل‌ها', 'callback_data' => $back_to_seasons_cb]];
                    editMessage($chat_id, $message_id_to_edit, "کیفیت را انتخاب کنید:", ['inline_keyboard' => $keyboard]);

                } elseif ($step == 'episode') {
                    $subtitle_type = $parts[5];
                    $quality = $parts[6];
                    $stmt = $db->prepare("SELECT id, title, episode, file_id FROM series WHERE imdb_id = ? AND season = ? AND subtitle_dubbed = ? AND quality = ? ORDER BY episode ASC");
                    $stmt->bind_param("siss", $imdb_id, $season, $subtitle_type, $quality);
                    $stmt->execute();
                    $episodes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                    $keyboard = [];
                    $episode_buttons = [];
                    foreach ($episodes as $ep) {
                        $episode_buttons[] = ['text' => '📂 قسمت ' . $ep['episode'], 'callback_data' => "getfile_series_{$ep['id']}_{$message_id_to_edit}"];
                    }
                    $keyboard = array_chunk($episode_buttons, 2); 
                    if (count($episodes) > 1) {
                         $keyboard[] = [['text' => '✅ دانلود تمام قسمت‌ها', 'callback_data' => "getall_series_{$imdb_id}_{$season}_{$subtitle_type}_{$quality}_{$message_id_to_edit}"]];
                    }
                    $keyboard[] = [['text' => '🔙 بازگشت به لیست کیفیت', 'callback_data' => "dl_series_quality_{$imdb_id}_{$season}_{$subtitle_type}_{$message_id_to_edit}"]];
                    $keyboard[] = [['text' => '🔙 بازگشت به لیست فصل‌ها', 'callback_data' => $back_to_seasons_cb]];
                    editMessage($chat_id, $message_id_to_edit, "قسمت مورد نظر را انتخاب کنید:", ['inline_keyboard' => $keyboard]);
                }

            } elseif ($type == 'movie') {
                 if ($step == 'quality') { 
                    $imdb_id = $parts[3];
                    $subtitle_type = $parts[4];
                    $message_id_to_edit = end($parts);
                    $back_to_filetype_cb = "dl_movie_filetype_{$imdb_id}_{$message_id_to_edit}";
                    $stmt = $db->prepare("SELECT id, title, quality, file_id FROM movies WHERE imdb_id = ? AND subtitle_dubbed = ?");
                    $stmt->bind_param("ss", $imdb_id, $subtitle_type);
                    $stmt->execute();
                    $qualities = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                    $keyboard = [];
                    foreach ($qualities as $item) {
                        $keyboard[] = [['text' => '🖥 ' . format_quality_name($item['quality']), 'callback_data' => "getfile_movie_{$item['id']}_{$message_id_to_edit}"]];
                    }
                    $keyboard[] = [['text' => '🔙 بازگشت به نوع فایل', 'callback_data' => $back_to_filetype_cb]];
                    editMessage($chat_id, $message_id_to_edit, "کیفیت را انتخاب کنید:", ['inline_keyboard' => $keyboard]);
                 }
                 elseif ($step == 'filetype'){
                    $imdb_id = $parts[3];
                    $message_id_to_edit = end($parts);
                    $stmt = $db->prepare("SELECT DISTINCT subtitle_dubbed FROM movies WHERE imdb_id = ?");
                    $stmt->bind_param("s", $imdb_id);
                    $stmt->execute();
                    $subtitles = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                    $keyboard = [];
                    foreach ($subtitles as $item) {
                        $sub_text = $item['subtitle_dubbed'] == 'subtitle' ? '📝 زیرنویس' : ($item['subtitle_dubbed'] == 'dubbed' ? '🎙 دوبله فارسی' : '📁 اصلی');
                        $keyboard[] = [['text' => $sub_text, 'callback_data' => "dl_movie_quality_{$imdb_id}_{$item['subtitle_dubbed']}_{$message_id_to_edit}"]];
                    }
                    editMessage($chat_id, $message_id_to_edit, "لطفا نوع فایل را انتخاب کنید:", ['inline_keyboard' => $keyboard]);
                 }
            }
            break;
            
        case 'getfile':
            $type = $parts[1];
            $content_id = $parts[2];
            $reply_to_msg_id = $parts[3] ?? $message_id;
            $table = $type == 'movie' ? 'movies' : 'series';

            $stmt = $db->prepare("SELECT * FROM {$table} WHERE id = ?");
            $stmt->bind_param("i", $content_id);
            $stmt->execute();
            $result = $stmt->get_result()->fetch_assoc();

            if ($result) {
                $file_type_text = '';
                switch ($result['subtitle_dubbed']) {
                    case 'dubbed': $file_type_text = "\n🎙 دوبله فارسی"; break;
                    case 'subtitle': $file_type_text = "\n📜 زیرنویس چسبیده"; break;
                    default: $file_type_text = "\n📁 فایل اصلی"; break;
                }
                $quality_formatted = format_quality_name($result['quality']);
                if ($type == 'movie') {
                    $caption = "🎥 <b>{$result['title']}</b>\n\n🖥 کیفیت: {$quality_formatted}{$file_type_text}" . $footer_caption;
                } else {
                    $caption = "📺 <b>{$result['title']}</b>\n\n🗓️ فصل: {$result['season']}\n🔰 قسمت: {$result['episode']}\n🖥 کیفیت: {$quality_formatted}{$file_type_text}" . $footer_caption;
                }
                
                $response = sendVideo($chat_id, $result['file_id'], $caption, $reply_to_msg_id);
                if (!$response || !$response['ok']) {
                    logMessage("sendVideo failed for content_id $content_id. Response: " . json_encode($response));
                    sendMessage($chat_id, "⚠️ متاسفانه در ارسال این فایل مشکلی پیش آمد. لطفاً به ادمین اطلاع دهید.");
                } else {
                    $title = $db->real_escape_string($result['title']);
                    $db->query("INSERT INTO downloads (content_id, content_type, user_id, title) VALUES ('$content_id', '$type', $user_id, '$title')");
                }
            }
            break;
            
        case 'getall':
            $type = $parts[1];
            if ($type == 'series') {
                $imdb_id = $parts[2]; $season = $parts[3]; $subtitle_type = $parts[4]; $quality = $parts[5];
                $reply_to_msg_id = $parts[6] ?? $message_id;

                $stmt = $db->prepare("SELECT * FROM series WHERE imdb_id = ? AND season = ? AND subtitle_dubbed = ? AND quality = ? ORDER BY episode ASC");
                $stmt->bind_param("siss", $imdb_id, $season, $subtitle_type, $quality);
                $stmt->execute();
                $results = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
                
                if(!empty($results)){
                    $confirmation_message = sendMessage($chat_id, "✅ درخواست شما برای ارسال تمام قسمت‌ها دریافت شد. فایل‌ها به زودی ارسال می‌شوند...");
                    $confirmation_message_id = $confirmation_message['result']['message_id'] ?? null;
                    
                    foreach($results as $result){
                        $file_type_text = '';
                        switch ($result['subtitle_dubbed']) {
                            case 'dubbed': $file_type_text = "\n🎙 دوبله فارسی"; break;
                            case 'subtitle': $file_type_text = "\n📜 زیرنویس چسبیده"; break;
                            default: $file_type_text = "\n📂 فایل اصلی"; break;
                        }
                        $quality_formatted = format_quality_name($result['quality']);
                        $caption = "📺 <b>{$result['title']}</b>\n\n🗓️ فصل: {$result['season']}\n🔰 قسمت: {$result['episode']}\n🖥 کیفیت: {$quality_formatted}{$file_type_text}" . $footer_caption;
                        
                        sendVideo($chat_id, $result['file_id'], $caption, $reply_to_msg_id);
                        $content_id = $result['id']; $title = $db->real_escape_string($result['title']);
                        $db->query("INSERT INTO downloads (content_id, content_type, user_id, title) VALUES ('$content_id', 'series', $user_id, '$title')");
                        usleep(500000); 
                    }
                    if ($confirmation_message_id) {
                        deleteMessage($chat_id, $confirmation_message_id);
                    }
                }
            }
            break;

        case 'request':
            $imdb_id = $parts[1] ?? ''; if (!$imdb_id) return;
            $info = getIMDbInfo($imdb_id); $title = $db->real_escape_string($info['title'] ?? 'Unknown');
            $time = time();
            $stmt = $db->prepare("INSERT INTO requests (imdb_id, user_id, title, request_time) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("sisi", $imdb_id, $user_id, $title, $time); $stmt->execute(); $req_id = $db->insert_id;
            
            sendMessage($chat_id, "✅ درخواست شما برای `".htmlspecialchars($title)."` به ادمین‌ها ارسال شد.");
            
            $admin_ids = array_merge(ADMIN_IDS, getAdditionalAdmins());
            $user_info = $callback_query['from']['first_name'] ?? "کاربر $user_id";
            $admin_text = "👤 درخواست جدید از: $user_info\n\nعنوان: ".htmlspecialchars($title)."\nIMDb: <code>$imdb_id</code>";
            $kb = ['inline_keyboard' => [[['text' => '✅ علامت‌گذاری به عنوان اضافه‌شده', 'callback_data' => "confirm_request_{$req_id}_{$user_id}_" . urlencode($title)]]]];
            
            foreach ($admin_ids as $admin_id) {
                $sent_message = sendMessage($admin_id, $admin_text, $kb);
                if($sent_message && $sent_message['ok']) {
                    pinChatMessage($admin_id, $sent_message['result']['message_id']);
                }
            }
            break;
            
        case 'confirm':
            if (($parts[1] ?? '') == 'request') {
                if (!isAdmin($user_id)) {
                    answerCallbackQuery($callback_query['id'], "شما دسترسی لازم را ندارید.", true);
                    return;
                }
                $req_id = $parts[2] ?? 0;
                $target_user_id = $parts[3] ?? 0;
                $title_parts = array_slice($parts, 4);
                $title_encoded = implode('_', $title_parts);
                $title = urldecode($title_encoded);

                answerCallbackQuery($callback_query['id'], 'درحال پردازش...', false);
                
                $db->query("UPDATE requests SET status='confirmed' WHERE id=$req_id");
                
                sendMessage($target_user_id, "خبر خوب! ✅\nدرخواست شما برای عنوان `".htmlspecialchars($title)."` انجام شد و هم اکنون در ربات موجود است.");
                
                $original_message_text = $callback_query['message']['text'];
                $new_text = $original_message_text . "\n\n✅ این درخواست توسط شما رسیدگی و به کاربر اطلاع داده شد.";
                
                editMessage($chat_id, $message_id, $new_text, null);
                unpinChatMessage($chat_id, $message_id);
            }
            break;
    }
}
?>